# These settings control the behavior of all chunks in the novice R materials.
# For example, to generate the lessons with all the output hidden, simply change
# `results` from "markup" to "hide".
# For more information on available chunk options, see
# http://yihui.name/knitr/options#chunk_options

library("knitr")

fix_fig_path <- function(pth) file.path("..", pth)

## We use the swc-rmd- prefix for the figures generated by the lssons
## so they can be easily identified and deleted by `make clean`.  The
## working directory when the lessons are generated is the root so the
## figures need to be saved in fig/, but when the site is generated,
## the episodes will be one level down. We fix the path using the
## `fig.process` option.
opts_chunk$set(tidy = FALSE, results = "markup", comment = NA,
               fig.align = "center", fig.path = "fig/swc-rmd-",
               fig.process = fix_fig_path)

# The hooks below add html tags to the code chunks and their output so that they
# are properly formatted when the site is built.
hook_in <- function(x, options) {
  stringr::str_c("\n\n~~~\n",
                 paste0(x, collapse="\n"),
                 "\n~~~\n{: .r}\n\n")
}

hook_out <- function(x, options) {
  x <- gsub("\n$", "", x)
  stringr::str_c("\n\n~~~\n",
                   paste0(x, collapse="\n"),
                 "\n~~~\n{: .output}\n\n")
}

hook_error <- function(x, options) {
  x <- gsub("\n$", "", x)
  stringr::str_c("\n\n~~~\n",
                 paste0(x, collapse="\n"),
                 "\n~~~\n{: .error}\n\n")
}

knit_hooks$set(source = hook_in, output = hook_out, warning = hook_error,
               error = hook_error, message = hook_out)
