#!/bin/sh
#
#################################
## Which version of the code ? ##
#################################
#
CODE_VERSION=5.3_GPU_VERSION_UEABS
KERNAME=code_saturne-$CODE_VERSION
#
################################################
## Installation PATH in the current directory ##
################################################
#
INSTALLPATH=`pwd`
INSTALLPATH=${INSTALLPATH}
#
echo $INSTALLPATH
#
#####################################
## Environment variables and PATHS ##
#####################################
#
NOM_ARCH=`uname -s`
export NOM_ARCH
#
##############
## Cleaning ##
##############
#
rm -rf $INSTALLPATH/$KERNAME/arch/*
rm -rf $INSTALLPATH/$KERNAME.build
#
#########################
## Kernel Installation ##
#########################
#
KERSRC=$INSTALLPATH/$KERNAME
KERBUILD=$KERSRC.build/arch/$NOM_ARCH
KEROPT=$KERSRC/arch/$NOM_ARCH
#
mkdir -p $KERBUILD
cd $KERBUILD
#
$KERSRC/configure \
--host=x86_64 \
--disable-shared \
--enable-openmp \
--disable-cuda-offload \
--without-modules \
--disable-rpath \
--disable-dlloader \
--disable-gui \
--disable-sockets \
--with-libxml2=no \
--enable-long-gnum \
--disable-mei \
--prefix=$KEROPT \
CC=mpicc FC=mpif90 CXX=mpicxx CFLAGS="-O3 -xCORE-AVX512 -Ofast" FCFLAGS="-O3 -xCORE-AVX512 -Ofast" CXXFLAGS="-std=gnu++0x"
#
make -j 8
make install
#
cd $INSTALLPATH
#
