# -*- coding: utf-8 -*-
# Package information, generated from cs_package.py.in by make.

#-------------------------------------------------------------------------------

# This file is part of Code_Saturne, a general-purpose CFD tool.
#
# Copyright (C) 1998-2018 EDF S.A.
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
# Street, Fifth Floor, Boston, MA 02110-1301, USA.

#-------------------------------------------------------------------------------

import os
import sys

import cs_config


# Package information
#--------------------

class package:

    def __init__(self, scriptdir=None):

        # System configuration (compilers, pre-requisites, ...)

        self.config = cs_config.config()

        # Package information

        self.name = "code_saturne"
        self.tarname = "code_saturne"
        self.pkgversion = "5.3-alpha"
        self.string = "code_saturne 5.3-alpha"
        self.bugreport = "saturne-support@edf.fr"
        self.url = "http://code-saturne.org"
        self.version = "5.3-alpha"
        self.version_full = "5.3-alpha"
        self.version_short = "5.3-alpha"
        self.revision = ""

        self.code_name = "Code_Saturne"

        self.preprocessor = "cs_preprocess" + self.config.exeext
        self.solver = "cs_solver" + self.config.exeext
        self.check_syntax = "cs_check_syntax" + self.config.exeext
        self.io_dump = "cs_io_dump" + self.config.exeext
        self.guiname = "SaturneGUI" + self.config.shext
        self.runcase = "runcase" + self.config.shext
        self.runsolver = "run_solver" + self.config.shext
        self.configfile = "code_saturne" + self.config.cfgext
        self.scratchdir = 'tmp_Saturne'
        self.srcdir = 'src_saturne'

        # Installation directories

        self.dirs = {'prefix': ("", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux"),
                     'exec_prefix': ("", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux"),
                     'bindir': ("bin", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/bin"),
                     'includedir': ("include", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/include"),
                     'pkgincludedir': (os.path.join("include", self.name),
                                       "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/include/code_saturne"),
                     'libdir': ("lib", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/lib"),
                     'libexecdir': ("libexec", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/libexec"),
                     'pkglibexecdir': (os.path.join("libexec", self.name),
                                       "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/libexec/code_saturne"),
                     'pythondir': (os.path.join("lib",
                                                "python" + sys.version[:3],
                                                "site-packages"),
                                   "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/lib/python2.7/site-packages"),
                     'pkgpythondir': (os.path.join("lib",
                                                   "python" + sys.version[:3],
                                                   "site-packages",
                                                   self.name),
                                      "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/lib/python2.7/site-packages/code_saturne"),
                     'localedir': (os.path.join("share", "locale"),
                                   "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/share/locale"),
                     'datarootdir': ("share", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/share"),
                     'datadir': ("share", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/share"),
                     'pkgdatadir': (os.path.join("share", self.name),
                                    "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/share/code_saturne"),
                     'docdir': (os.path.join("share", "doc", self.name),
                                "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/share/doc/code_saturne"),
                     'pdfdir': (os.path.join("share", "doc", self.name),
                                "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/share/doc/code_saturne"),
                     'sysconfdir': ("etc", "/ccc/cont005/home/pa4787/moulinec/INTEL_17.0.6.256_OMPI_2.0.4_SKYLAKE/CS_5.3_PRACE_UEABS/code_saturne-5.3_GPU_VERSION_UEABS/arch/Linux/etc")}

    def get_dir(self, installdir):

        # First, handle the standard "non relocatable" case
        if self.config.features['relocatable'] == "no":
            return self.dirs[installdir][1]

        # Second, check if CS_ROOT_DIR is set
        prefix = os.getenv('CS_ROOT_DIR')

        # Third, assume that SALOME is being used
        if prefix == None:
            prefix = os.getenv('CFDMODULE_ROOT_DIR')

        # Last, assume that the standard tree structure is used
        if prefix == None:
            prefix = os.path.dirname(os.path.realpath(__file__))
            i = prefix.find(self.dirs['pythondir'][0])
            if i > -1:
                prefix = os.path.dirname(prefix[:i+1])

        return os.path.join(prefix, self.dirs[installdir][0])

    def get_preprocessor(self):

        return os.path.join(self.get_dir("pkglibexecdir"),
                            self.preprocessor)

    def get_io_dump(self):

        return os.path.join(self.get_dir("pkglibexecdir"),
                            self.io_dump)

    def get_solver(self):

        return os.path.join(self.get_dir("pkglibexecdir"),
                            self.solver)

    def get_check_syntax(self):

        return os.path.join(self.get_dir("pkglibexecdir"),
                            self.check_syntax)

    def get_io_dump(self):

        return os.path.join(self.get_dir("pkglibexecdir"),
                            self.io_dump)

    def get_global_configfile(self):

        # Windows XP:         C:\Documents and Settings\All Users
        # Windows Vista/7/8:  C:\ProgramData
        # Linux and co:       /etc

        if sys.platform.startswith("win"):
            # One could use PROGRAMDATA but it is not available on Windows XP
            configdir = os.path.join(os.getenv("ALLUSERSPROFILE"),
                                     self.code_name, self.version_short)
        else:
            configdir = self.get_dir("sysconfdir")

        return [os.path.join(configdir, self.configfile)]

    def get_user_configfile(self):

        # Windows XP:         C:\Documents and Settings\{user}\Application Data
        # Windows Vista/7/8:  C:\Users\{user}\AppData\Roaming
        # Linux and co:       /home/{user}   (or similar)

        if sys.platform.startswith("win"):
            configdir = os.path.join(os.getenv("APPDATA"),
                                     self.code_name, self.version_short)
            return [os.path.join(configdir, self.configfile)]
        else:
            configdir = os.path.expanduser("~")
            return [os.path.join(configdir, "." + self.configfile)]

    def get_configfiles(self):

        u_cfg = self.get_user_configfile()
        g_cfg = self.get_global_configfile()

        return g_cfg + u_cfg

    def get_batchdir(self):

        return os.path.join(self.get_dir("pkgdatadir"),
                            'batch')

    def get_runcase_script(self, script):

        return os.path.join(self.get_dir("pkgdatadir"),
                            script)

    def get_alternate_version(self, version):
        """
        Return alternate version package object
        """

        if not version:
            return self

        pkg = None

        # Determine path (by absolute or local name)
        pythondir = os.path.normpath(version)
        prefix = os.path.normpath(self.get_dir("exec_prefix"))
        if self.get_dir("pkgpythondir").find(prefix) > -1:
            postfix = self.get_dir("pkgpythondir")[len(prefix)+1:]
            if not os.path.isabs(pythondir):
                prefix = os.path.split(prefix)[0]
            else:
                prefix = version
            pythondir = os.path.normpath(os.path.join(prefix,
                                                      version,
                                                      postfix))

        # load alternate package
        if os.path.isdir(pythondir):
            import sys
            sys.path.insert(0, pythondir)
            if sys.version < '3.4':
                import cs_config
                reload(cs_config)
                import cs_package
                reload(cs_package)
            else:
                import importlib
                import cs_config
                importlib.reload(cs_config)
                import cs_package
                importlib.reload(cs_package)
            pkg = cs_package.package()
            sys.path.pop(0)
        else:
            raise ImportError("Alternative version '" + pythondir + "' not found.")

        return pkg

    def get_cross_compile(self):
        """
        Return cross-conpilation info
        """
        return self.config.features['build_os']

#-------------------------------------------------------------------------------
