!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics programme
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003-2006, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! dsd.F90  ---  p(j,x,mu) := p(j,x,mu) - step * D_{x,mu,j} S_det
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine dsd(p, conf, step, para)

  use typedef_hmc
  use module_hmc_forces
  use module_vol
  implicit none

  type(hmc_para),  intent(in)    :: para
  type(hmc_conf),  intent(in)    :: conf
  GENERATOR_FIELD, intent(inout) :: p
  REAL,            intent(in)    :: step
  REAL                           :: s

  s = -step * TWO * (para%csw_kappa / EIGHT)
  
  if (s /= ZERO) then
     call hmc_forces_old(p)
     call clover_dsd(ODD, p, conf%b, s, conf%u)
     call hmc_forces_new(p, step, i_sd)
  endif

end

!===============================================================================
