!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics programme
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2006, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! dsg.F90  -  p(j,x,mu) := p(j,x,mu) - step * D_{x,mu,j} S_g
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine dsg(p, u, step, beta)

  use module_hmc_forces
  use module_vol
  implicit none

  GENERATOR_FIELD, intent(inout) :: p
  GAUGE_FIELD,     intent(in)    :: u
  REAL,            intent(in)    :: step, beta
  REAL                           :: s
  SU3                            :: uuu, w
  integer                        :: mu, eo, i

  if (beta == ZERO) return

  TIMING_START(timing_bin_dsg)

  call hmc_forces_old(p)

  s = -step * beta / THREE

  do mu = 1, DIM
     do eo = EVEN, ODD
        !$omp parallel do private(uuu, w)
        do i = 1, volh
           call staple(uuu, u, i, eo, mu)
           call uu(w, u(1, 1, i, eo, mu), uuu)
           call im_tr_j(p(1, i, eo, mu), w, s)
        enddo
     enddo
  enddo

  call hmc_forces_new(p, step, i_sg)

  TIMING_STOP(timing_bin_dsg)
end

!===============================================================================
