!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! module_function_decl.F90  -  declaration of functions
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
module module_function_decl

  ! functions in misc.F90:

  character(len=10), external :: datum
  character(len=12), external :: uhrzeit
  character(len=20), external :: rechner
  logical, external :: f_exist

  ! processes (-> comm/pes*.F90):

  integer, external :: num_pes

#ifdef CRAY
  integer, intrinsic :: my_pe  ! gives the same id as MPI_Rank in MPI_COMM_WORLD
#else
  integer, external :: my_pe
#endif

  ! global reduction (-> comm/reduction_*.F90)

  REAL, external :: dotprod
  REAL, external :: global_sum
  real, external :: global_min
  real, external :: global_max

  ! sc-field (-> sc.F90)

  REAL, external    :: sc_norm2
  REAL, external    :: sc_dot
  COMPLEX, external :: sc_cdotc

  ! ranf:

#ifdef CRAY
  real(8), intrinsic :: ranf
#else
  real(8), external :: ranf
#endif

  ! identification of D (-> d/DVersion.F90)

  integer, external :: version_of_d
  integer, external :: get_d3_buffer_vol

  ! communication method (-> comm/comm_*.F90)

  COMM_METHOD, external :: comm_method

end
!===============================================================================
