!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2005, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! mtdagmt.F90 - -> see m_tilde.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine mtdagmt(out, in, para, conf)

  use typedef_hmc
  use module_p_interface
  use module_vol
  implicit none

  type(hmc_para), intent(in) :: para
  type(hmc_conf), intent(in) :: conf

  SPINCOL_FIELD         :: out, in
  P_SPINCOL_FIELD, save :: tmp   

  TIMING_START(timing_bin_mtdagmt)

  ALLOCATE_SC_FIELD(tmp)

  call mtil(tmp, in, para, conf)
  call mtil_dag(out, tmp, para, conf)

  TIMING_STOP(timing_bin_mtdagmt)
end

!===============================================================================
