!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2001, Hinnerk Stueben, Zuse Institute Berlin
!
!-------------------------------------------------------------------------------
!
! ranf_test - test of "ranf.F90"
!
!-------------------------------------------------------------------------------

program ranf_test

  implicit none
  integer(8), parameter :: null = 0
  integer(8) :: i, seed
  real(8) :: x, ranf

  write(6,400) "default seed:"

  do i = 1, 10
     call ranget(seed)
     x = ranf()
     write(6,410) i, seed, x
  enddo

  write(6,400) "seed = 4711:"

  call ranset(4711_8, null)

  do i = 1, 10
     call ranget(seed)
     x = ranf()
     write(6,410) i, seed, x
  enddo

  write(6,400) "seed varies, no skip:"

  do i = -10, 20
     call ranset(i, null)
     call ranget(seed)
     x = ranf()
     write(6,410) i, seed, x
  enddo

  write(6,400) "default seed, skip varies:"

  do i = -10, 20
     call ranset(null, i)
     call ranget(seed)
     x = ranf()
     write(6,410) i, seed, x
  enddo

  write(6,400) "large seeds, no skip:"

  do i = 0, 47
     call ranset(2_8**i, null)
     call ranget(seed)
     x = ranf()
     write(6,410) i, seed, x
  enddo

  write(6,400) "default seeds, big skips:"

  do i = 0, 47
     call ranset(null, 2_8**i)
     call ranget(seed)
     x = ranf()
     write(6,410) i, seed, x
  enddo


400 format (//1x,a//)
410 format (i6,i24,f24.16)

end

!===============================================================================
