!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! staple.F90 - calculates sum of staples for one link
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine staple(uuu, u, i, e, mu)

  use module_nn
  use module_vol
  implicit none

  SU3, intent(out) :: uuu
  GAUGE_FIELD, intent(in) :: u
  integer, intent(in) :: i, e, mu
  integer :: o, nu, j1, j2, j3, j4

  o = EVEN + ODD - e
  uuu = 0

  do nu = 1, DIM
     if (nu /= mu) then

        !  (j2,o) --<--   x        nu
        !    |            |        
        !    v            ^         ^
        !    |            |         |
        !  (i,e)  -->-- (j1,o)      x-->  mu
        !    |            |
        !    ^            v
        !    |            |
        !  (j3,o) --<-- (j4,e)


        j1 = nn(i, e, mu, FWD)
        j2 = nn(i, e, nu, FWD)
        j3 = nn(i, e, nu, BWD)
        j4 = nn(j3,o, mu, FWD)

        if (j4 /= nn(j1, o, nu, BWD)) call die('staple(): j4 inconsistent')
        if (nn(j1, o, nu, FWD) /= nn(j2, o, mu, FWD)) &
           call die('staple(): j12 inconsistent')

        call uuu_fwd(uuu, u(1, 1, j1, o, nu), &
                          u(1, 1, j2, o, mu), &
                          u(1, 1, i, e, nu))

        call uuu_bwd(uuu, u(1, 1, j4, e, nu), &
                          u(1, 1, j3, o, mu), &
                          u(1, 1, j3, o, nu))
        
     endif
  enddo

end

!===============================================================================
